Unit Player;
Interface
	Type
		PlayerType = Record
			Score: Longword;
			IsJump, IsDown: Boolean;
			Tick: Byte;
		End;

	Procedure PlayerInit(Var Player: PlayerType);
	Procedure PlayerUpdate(Var Player: PlayerType);
	Procedure PlayerJump(Var Player: PlayerType);
	Procedure PlayerDown(Var Player: PlayerType);

Implementation
	Const
		ActionTime = 3;

	Procedure PlayerInit(Var Player: PlayerType);
	Begin
		Player.Tick := 0;
		Player.Score := 0;
		Player.IsDown := False;
		Player.IsJump := False;
	End;

	Procedure PlayerUpdate(Var Player: PlayerType);
	Begin
		Player.Tick := Player.Tick + 1;
		Player.Score := Player.Score + 1;
		If Player.Tick >= ActionTime Then
		Begin
			Player.Tick := 0;
			Player.IsJump := False;
			Player.IsDown := False;
		End;
	End;

	Procedure PlayerJump(Var Player: PlayerType);
	Begin
		If Not Player.IsDown Then
		Begin
			If Not Player.IsJump Then
				Player.Tick := 0;
			Player.IsJump := True;
		End;
	End;

	Procedure PlayerDown(Var Player: PlayerType);
	Begin
		If Not Player.IsJump Then
		Begin
			If Not Player.IsDown Then
				Player.Tick := 0;
			Player.IsDown := True;
		End;
	End;
End.
