Program Todo;
Type
	TaskPtrType = ^TaskType;
	TaskType = Record
		Data: String;
		Next, Previous: TaskPtrType;
	End;
	TodoType = Record
		First, Last: TaskPtrType;
	End;
Const
	PathToTodoList = '.todolist';


Function Power(Number: Byte; Exponent: Byte): Word;
Var
	I: Byte;
Begin
	If Exponent = 0 Then
	Begin
		Power := 1;
		Exit;
	End;
	Power := Number;
	For I := 0 To Exponent Do
	Begin
		Power := Power * Power;
	End;
End;

Function StringToWord(Number: String): Word;
Var
	I: Byte;
Begin
	StringToWord := 0;
	For I := Length(Number) Downto 1 Do
	Begin
		StringToWord := StringToWord +
			(Ord(Number[I]) - 48) * Power(10, Length(Number) - I);
	End;
End;

Procedure AddToTodo(Var Todo: TodoType; Data: String);
Var
	Tmp: TaskPtrType;
Begin
	New(Tmp);
	Tmp^.Data := Data;
	Tmp^.Next := Todo.First;
	If Tmp^.Next <> Nil Then
		Tmp^.Next^.Previous := Tmp;
	Todo.First := Tmp;
	If Todo.Last = Nil Then
		Todo.Last := Todo.First;
End;

Procedure CheckIOResult();
Begin
	If IOResult <> 0 Then
	Begin
		Writeln('Coulndn`t open ', PathToTodoList, ' file!');
		Halt(1);
	End;
End;

Procedure ClearTodoList();
Var
	TodoFile: Text;
Begin
	Assign(TodoFile, PathToTodoList);
	Rewrite(TodoFile);
	Close(TodoFile);
End;

Procedure RemoveFromTodoList(LineRemoveNumber: Word);
Var
	TodoFile: Text;
	LineNumber: Word;
	Line: String;
	Todo: TodoType;
	Tmp: TaskPtrType;
Begin
	Assign(TodoFile, PathToTodoList);
	Reset(TodoFile);
	CheckIOResult();
	LineNumber := 0;
	While Not SeekEof(TodoFile) Do
	Begin
		Readln(TodoFile, Line);
		LineNumber := LineNumber + 1;
		If LineRemoveNumber = LineNumber - 1 Then
			Continue;
		AddToTodo(Todo, Line);
	End;
	Close(TodoFile);
	Rewrite(TodoFile);
	Tmp := Todo.Last;
	While Tmp <> Nil Do
	Begin
		Writeln(TodoFile, Tmp^.Data);
		Tmp := Tmp^.Previous;
	End;
	Close(TodoFile);
End;

Procedure WriteTodoList();
Var
	I: Byte;
	LineNumber: Word;
	TodoFile: Text;
	Line: String;
Begin
	{$I-}
	Assign(TodoFile, PathToTodoList);
	Reset(TodoFile);
	CheckIOResult();
	LineNumber := 0;
	While Not SeekEof(TodoFile) Do
	Begin
		Readln(TodoFile, Line);
		Write('[', LineNumber, '] ');
		Write('(', Line[1], ')');
		For I := 2 To Length(Line) Do
			Write(Line[I]);
		Writeln();
		LineNumber := LineNumber + 1;
	End;
	Close(TodoFile);
End;

Procedure AddToTodoList(Data: String; Priority: Char);
Var
	TodoFile: Text;
Begin
	If (Priority > '9') Or (Priority < '0') Then
	Begin
		Writeln('Priority can only be a number');
		Halt(1);
	End;
	Assign(TodoFile, PathToTodoList);
	Append(TodoFile);
	If IOResult <> 0 Then
	Begin
		ClearTodoList();
		Append(TodoFile);
	End;
	CheckIOResult();
	Writeln(TodoFile, Priority, ' ', Data);
	Close(TodoFile);
End;

Begin
	If ParamCount() < 1 Then
		WriteTodoList();
	If Paramstr(1) = 'add' Then
	Begin
		If ParamCount() < 3 Then
			AddToTodoList(ParamStr(2), '0')
		Else
			AddToTodoList(Paramstr(2), Paramstr(3)[1]);
	End;
	If Paramstr(1) = 'clear' Then
		ClearTodoList();
	If ParamStr(1) = 'remove' Then
	Begin
		If ParamCount() < 2 Then
		Begin
			Writeln('Must insert task number');
			Halt(1);
		End;
		RemoveFromTodoList(StringToWord(ParamStr(2)));
	End;
End.
