#include "bot.h"
#include <stdlib.h>
#include <time.h>

struct bot_item *create_bots(unsigned int count)
{
	struct bot_item *first=NULL, *tmp;
	int i;
	srand(time(0));
	for (i = 0; i < count; i++) {
		tmp = malloc(sizeof(*tmp));
		tmp->data.price_best = rand() % (150 - 50 + 1) + 50;
		tmp->data.price_proposed = rand() % (150 - 50 + 1) + 50;
		tmp->data.price_cap = rand() % (150 - 50 + 1) + 50;
		tmp->score = 0;
		tmp->next = first;
		first = tmp;
	}
	return first;
}

void sort_bots(struct bot_item *bots)
{
	struct bot_item *tmp;
	double score;
	struct bot data;
	char is_sorted = 0;
	if (!bots) /* empty list */
		return;
	while (!is_sorted) {
		is_sorted = 1;
		for(tmp = bots; tmp->next; tmp = tmp->next)
			if ((tmp->score) < (tmp->next->score)) {
				score = tmp->score;
				data = tmp->data;
				tmp->score = tmp->next->score;
				tmp->data = tmp->next->data;
				tmp->next->score = score;
				tmp->next->data = data;
				is_sorted = 0;
			}
	}
}

struct bot_item *delete_bots(struct bot_item *bots, int count)
{
	struct bot_item *tmp;
	if ((count <= 0) || (bots == NULL))
		return bots;
	tmp = delete_bots(bots->next, count-1);
	free(bots);
	return tmp;
}

void clear_bots(struct bot_item *bots)
{
	if (!bots)
		return;
	if (bots->next)
		clear_bots(bots->next);
	free(bots);
}
