<?php

require_once __DIR__ . '/../lib/types.php';

class RAM extends Component {
    private $addresses = [];
    public readonly int $bytes;

    public function __construct(string $bytes = "1024") {
        $this->bytes = intval($bytes);
    }

    public function read(int $byte) : int {
        if(!isset($this->addresses[$byte])) {
            return 0;
        }
        return $this->addresses[$byte];
    }
    public function write(int $byte, int $value) : void {
        if($value === 0) {
            unset($this->addresses[$byte]);
            return;
        }
        $this->addresses[$byte] = $value;
    }
}
